import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib
import numpy as np
from statannot import add_stat_annotation

from matplotlib.axes._axes import Axes
from matplotlib.markers import MarkerStyle
import matplotlib.markers as mmarkers
from seaborn import color_palette
from numpy import ndarray
from scipy import stats

sigLevel=1e-03

# Define plotting utilities
class CM():
	def __init__(self, markers=["o"], markerColor='k'):
		self.marker = np.array(markers)
		self.markerColor = markerColor
		self.colors = []
	def setMarkers(self, markers):
		self.marker = np.array(markers)
	def setMarkerColor(self, markerColor):
		self.markerColor = markerColor
	def get_markers_for_colors(self, c):
		for _co in c:
			if not any((_co == x).all() for x in self.colors):
				self.colors.append(_co)
		ind = np.array([np.where((self.colors == row).all(axis=1)) for row in c]).flatten()
		return self.marker[ind % len(self.marker)]
	def get_legend_handles(self, **kwargs):
		return [plt.Line2D([0], [0], ls="none", marker=m, color=self.markerColor, mec="none", **kwargs) for m in self.marker]
cm = CM(plt.Line2D.filled_markers)
old_scatter = Axes.scatter
def new_scatter(self, *args, **kwargs):
	c = kwargs.get("c", None)
	axs = kwargs.pop("markeraxis", None)
	markersize = kwargs.pop("markersize", None)
	markers = kwargs.pop("markers", None)
	color = kwargs.pop("markercolor", None)
	sc = old_scatter(self, *args, **kwargs)
	if axs and markersize and markers and color:
		if isinstance(c, np.ndarray):
			cm.setMarkers(markers)
			m = cm.get_markers_for_colors(c)
			paths = []
			for _m in m:
				marker_obj = mmarkers.MarkerStyle(_m)
				paths.append(marker_obj.get_path().transformed(
					marker_obj.get_transform()))
			sc.set_paths(paths)
			for collection in axs.collections:
				collection.set_facecolor(color)
				# collection.set_sizes([8*5])
			cm.setMarkerColor(color)
	return sc
Axes.scatter = new_scatter
# Define plotting settings
# sns.set(font='Calibri')
dpi = 200
sns.set(style="white", color_codes=True)
order = ['None', 'AOM', 'DSS', 'AOM/DSS']
# Read the colon weights dataset
dfc = pd.read_csv("colon_weights.csv")
# Read the animal weights dataset
dfa = pd.read_csv("animal_weights.csv")
# Inspect the dataset
# dfc.head()
# dfc.columns
# dfa.head()
# dfa.columns

# Discard measudements from animals that were culled early (not according to schedule)
dfc = dfc.drop(dfc[~dfc['Treatment'].str[:2].isin(['24', '45', '66'])].index)
dfc['Culling day'] = dfc['Treatment'].str[:2]
dfc.loc[dfc['Culling day']=='24', 'cycle'] = 'Cycle 1'
dfc.loc[dfc['Culling day']=='45', 'cycle'] = 'Cycle 2'
dfc.loc[dfc['Culling day']=='66', 'cycle'] = 'Cycle 3'
# print set(dfc['Treatment'])
# Compute meta-measurements
dfc['Colon weight-to-length [mg/cm]'] = dfc['Colon weight [g]']*1000/dfc['Colon length [cm]']

for a in set(dfa['Animal']):
	an = dfa['Animal']==a
	da = dfa['Day']==3
	baseWeight = float(dfa[an & da]['Weight'])
	dfa.loc[dfa['Animal']==a, 'BaseWeight'] = baseWeight
# Compute the relative animal weight
dfa['Mean relative body weight [%]'] = dfa['Weight']/dfa['BaseWeight']*100
#%% Make the plots
# Plot the colon length
fig = plt.figure(dpi=dpi)
ax = sns.boxplot(x='Group', y='Colon length [cm]', data=dfc, width=0.5, order=order, color='white', fliersize=0)
ax = sns.swarmplot(x='Group', y='Colon length [cm]', data=dfc, order=order, hue='cycle', ax=ax, markeraxis=ax, markercolor='k', markersize=8, markers=["D","o",'X'], dodge=True)
_, l = ax.get_legend_handles_labels()
ax.legend(cm.get_legend_handles(markersize = 5), l)
test = 'Kruskal'
# NoneG = dfc.loc[dfc['Group']=='None', 'Colon length [cm]']
# AOMG = dfc.loc[dfc['Group']=='AOM', 'Colon length [cm]']
# DSSG = dfc.loc[dfc['Group']=='DSS', 'Colon length [cm]']
# AOMDSSG = dfc.loc[dfc['Group']=='AOM/DSS', 'Colon length [cm]']
# print NoneG.describe()
# print DSSG.describe()
# print AOMDSSG.describe()
# print stats.kruskal(NoneG, AOMG, DSSG, AOMDSSG)
# print stats.kruskal(NoneG, AOMDSSG)
add_stat_annotation(ax, data=dfc, x='Group', y='Colon length [cm]', test=test, box_pairs=[ ['None', 'AOM/DSS'], ['None', 'DSS'], ['None', 'AOM']], text_format='star', loc='outside', verbose=4, order=order)
ax.annotate('a', xy=(.037, .973), xycoords='figure fraction', horizontalalignment='left', verticalalignment='top', fontsize=15, weight='bold')
fig.savefig('../Figures/Chapter 2/colon_length.png', bbox_inches="tight")
plt.show()


# Plot the colon weight to length ratio
fig = plt.figure(dpi=dpi)
ax = sns.boxplot(x='Group', y='Colon weight-to-length [mg/cm]', data=dfc, width=0.5, order=order, color='white', fliersize=0)
ax = sns.swarmplot(x='Group', y='Colon weight-to-length [mg/cm]', data=dfc, order=order, hue='cycle', ax=ax, markeraxis=ax, markercolor='k', markersize=8, markers=["D","o",'X'], dodge=True)
_, l = ax.get_legend_handles_labels()
ax.legend(cm.get_legend_handles(markersize = 5), l)
# w1, p1 = stats.shapiro(dfc.loc[dfc['Group']=='DSS', 'Colon weight-to-length [mg / cm]'])
# w2, p2 = stats.shapiro(dfc.loc[dfc['Group']=='AOM/DSS', 'Colon weight-to-length [mg / cm]'])
# if test=='t-test_welch' and not (p1<sigLevel and p2<sigLevel):
# 	raise Exception('Distributions are not normal. Shapiro p-values: {:.3f}, {:.3f}. Consider using the Mann-Whitney U test.'.format(p1, p2))
test = 'Kruskal'
add_stat_annotation(ax, data=dfc, x='Group', y='Colon weight-to-length [mg/cm]', test=test, box_pairs=[['DSS', 'AOM/DSS'], ['None', 'DSS'], ['None', 'AOM']], text_format='star', loc='outside', verbose=4, order=order)
ax.annotate('b', xy=(.02, .973), xycoords='figure fraction', horizontalalignment='left', verticalalignment='top', fontsize=15, weight='bold')
fig.savefig('../Figures/Chapter 2/colon_weight-to-length.png', bbox_inches="tight")
plt.show()
#%% Get the statistics of individual groups
dfc[dfc['Group']=='None'].describe()
dfc[dfc['Group']=='AOM'].describe()
#%% Plot the relative animal weight

fig = plt.figure(dpi=dpi)
sns.set_style("ticks")
ax = sns.lineplot(x='Day', y="Mean relative body weight [%]", hue="Group", style="Group", data=dfa, err_style="bars", markers=True, dashes=False, hue_order=order, ci='sd', markersize=5)
#set the AOM arrow
# ax.annotate('', xy=(1, 100), xytext=(1, 70.55), arrowprops=dict(arrowstyle="-", linestyle="--", color='grey', mutation_scale=5))
ax.annotate('', xy=(1, 74), xytext=(1, 70.55), arrowprops=dict(arrowstyle="-|>", color='r', mutation_scale=5))
ax.legend(markerscale=1.2)
plt.setp(ax.get_legend().get_texts(), fontsize='10')

# Add the blue ribbons on the bottom
ax.add_patch(matplotlib.patches.Rectangle(xy=(3, 70), width=6, height=3, fill=True))
ax.add_patch(matplotlib.patches.Rectangle(xy=(24, 70), width=6, height=3, fill=True))
ax.add_patch(matplotlib.patches.Rectangle(xy=(45, 70), width=6, height=3, fill=True))

# Set the "Cycle" annotations
y = -0.23
ax.annotate('', xy=(0.04, y), xycoords='axes fraction', xytext=(0.355, y), arrowprops=dict(arrowstyle="|-|", color='k', mutation_scale=5))
ax.annotate('Cycle 1', xy=(0.04, y), xycoords='axes fraction', xytext=(0.2, y), backgroundcolor="w", ha='center', va='center')
off = 0.303
ax.annotate('', xy=(0.04+off, y), xycoords='axes fraction', xytext=(0.355+off, y), arrowprops=dict(arrowstyle="|-|", color='k', mutation_scale=5))
ax.annotate('Cycle 2', xy=(0.04+off, y), xycoords='axes fraction', xytext=(0.2+off, y), backgroundcolor="w", ha='center', va='center')
off = 2*off
ax.annotate('', xy=(0.04+off, y), xycoords='axes fraction', xytext=(0.355+off, y), arrowprops=dict(arrowstyle="|-|", color='k', mutation_scale=5))
ax.annotate('Cycle 3', xy=(0.04+off, y), xycoords='axes fraction', xytext=(0.2+off, y), backgroundcolor="w", ha='center', va='center')

ax.set(ylim=(71, 140))
# ax.xaxis.set_major_locator(plt.MaxNLocator(13))
specialticks = [1, 3, 9, 24, 30, 45, 51, 66]
plt.xticks(specialticks, specialticks)
# tickLabels = [t if t in specialticks else '' for t in range(1, 67)]
# ticks = [t for t in range(1, 67)]
# plt.xticks(ticks, tickLabels)
plt.show()
fig.savefig('../Figures/Chapter 2/animal_relative_weight.png', bbox_inches="tight")
